/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.viewer.mapui;

import filenet.sim.toolkit.viewer.VWSIMAnimatorStep;
import filenet.sim.toolkit.viewer.mapui.IVWSIMAnimatorStepUI;
import filenet.sim.toolkit.viewer.mapui.VWSIMAnimatorMapAttribs;
import filenet.sim.toolkit.viewer.mapui.images.VWSIMImageLoader;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.event.VWPropertyChangeNotifier;
import filenet.vw.toolkit.utils.mapui.VWBaseStepUI;
import filenet.vw.toolkit.utils.mapui.VWImageAttrUI;
import filenet.vw.toolkit.utils.mapui.VWLabelUI;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class VWSIMAnimatorStepUI
implements IVWSIMAnimatorStepUI {
    private static int s_hGap = 2;
    private static int s_vGap = 2;
    private Frame m_parentFrame = null;
    private VWBaseStepUI m_stepUI = null;
    private VWSIMAnimatorStep m_step = null;
    private VWSIMAnimatorMapAttribs m_mapAttribs = null;
    private ImageIcon m_statusIcon = null;
    private Date m_date = null;
    private String m_dateString = null;
    private Dimension m_stepCountDim = null;
    private String m_stepCountString = null;
    private Point m_offset = new Point(0, -20);
    private boolean m_bUpdate = true;
    private Font m_font = null;
    private FontMetrics m_fm = null;
    private int m_fontHeight = 0;
    private int m_fontAscent = 0;
    private int m_defaultFontHeight = 20;
    private Dimension m_runtimeInfoDim = new Dimension(0, this.m_defaultFontHeight);
    private JPopupMenu m_popup = null;
    protected static Image s_workItemImage = null;
    protected static ImageIcon s_tokenIcon = null;
    protected static int s_workItemImageWidth = 0;
    protected static int s_workItemImageHeight = 0;
    private static final int WORKITEM_FLASH_COUNT = 1;
    private VWLabelUI m_workItemIcon = new VWLabelUI();
    private boolean m_bFlashWorkItem = false;
    private int m_currentWorkItemFlashCount = 0;

    public VWSIMAnimatorStepUI(Frame parentFrame, VWBaseStepUI stepUI, VWSIMAnimatorStep step, boolean bLaunchStep, VWSIMAnimatorMapAttribs mapAttribs) {
        ImageIcon imageIcon;
        this.m_stepUI = stepUI;
        this.m_parentFrame = parentFrame;
        this.m_step = step;
        this.m_mapAttribs = mapAttribs;
        if (s_workItemImage == null && (imageIcon = VWSIMImageLoader.createImageIcon("animate_step.gif")) != null) {
            s_workItemImageWidth = imageIcon.getIconWidth();
            s_workItemImageHeight = imageIcon.getIconHeight();
            s_workItemImage = imageIcon.getImage();
            s_tokenIcon = imageIcon;
        }
    }

    public VWSIMAnimatorStep getStepData() {
        return this.m_step;
    }

    public int getId() {
        return this.m_step.getStepId();
    }

    public String getName() {
        return this.m_step.getStepName();
    }

    public synchronized void paintComponent(Graphics g) {
        if (!this.m_mapAttribs.isStepStatusVisible()) {
            return;
        }
        if (this.m_font == null) {
            Font font = g.getFont();
            this.m_font = new Font(font.getName(), font.getStyle(), font.getSize());
            this.m_fm = this.m_stepUI.getFontMetrics(this.m_font);
        }
        this.updateDimension(g);
        if (this.m_offset != null) {
            Rectangle imageRect = this.m_stepUI.getImageBounds();
            int x = this.m_offset.x + imageRect.x;
            int y = this.m_offset.y + imageRect.y;
            if (this.m_stepCountString != null) {
                g.drawString(this.m_stepCountString, x + 1, y + this.m_fontAscent);
            }
        }
        if (this.m_bFlashWorkItem && this.m_currentWorkItemFlashCount <= 1) {
            if (this.m_currentWorkItemFlashCount % 2 == 0) {
                Point pt = this.m_stepUI.getImageCenterLocation();
                pt.x -= s_workItemImageWidth / 2;
                pt.y -= s_workItemImageHeight / 2;
                if (pt != null) {
                    s_tokenIcon.paintIcon(null, g, pt.x, pt.y);
                }
            }
            ++this.m_currentWorkItemFlashCount;
            if (this.m_currentWorkItemFlashCount > 1) {
                this.flashWorkItem(false);
            }
        }
    }

    public void flashWorkItem(boolean bFlash) {
        this.m_bFlashWorkItem = bFlash;
        this.m_currentWorkItemFlashCount = 0;
        this.m_workItemIcon.removeAllAttributes();
        if (bFlash) {
            this.m_workItemIcon.addAttribute(new VWImageAttrUI(s_workItemImage));
        }
    }

    public boolean isFlashingWorkItem() {
        return this.m_bFlashWorkItem;
    }

    public Rectangle getBounds(Rectangle rect) {
        if (rect == null) {
            rect = new Rectangle(10, 10);
        }
        int loop = 0;
        do {
            if (this.m_runtimeInfoDim != null && this.m_offset != null) {
                Rectangle imageRect = this.m_stepUI.getImageBounds();
                Rectangle r = new Rectangle();
                int x = imageRect.x + this.m_offset.x;
                int y = imageRect.y + this.m_offset.y;
                int right = x + this.m_runtimeInfoDim.width;
                r.y = y;
                r.height = rect.height + this.m_runtimeInfoDim.height;
                r.x = x < rect.x ? x : rect.x;
                right = right > rect.x + rect.width ? right : rect.x + rect.width;
                r.width = right - r.x;
                rect = r;
            }
            ++loop;
            if (!this.m_bUpdate) break;
            this.updateDimension(null);
        } while (loop < 2);
        return rect;
    }

    public void createPopup(Container container, MouseEvent evt) {
        Object source = evt.getSource();
        Point point = evt.getPoint();
    }

    public void notifyPropertyChange() {
        VWPropertyChangeNotifier.notifyPropertyChange(new VWPropertyChangeEvent(this, 702));
    }

    public Vector getItemsChanged() {
        Vector<VWSIMAnimatorStep> steps = new Vector<VWSIMAnimatorStep>();
        steps.addElement(this.m_step);
        return steps;
    }

    private void updateDimension(Graphics g) {
        if (this.m_bUpdate) {
            int height = 0;
            int width = 0;
            int w = 0;
            boolean h = false;
            FontMetrics fm = null;
            fm = g == null ? this.m_fm : g.getFontMetrics();
            if (fm == null) {
                return;
            }
            this.m_fontHeight = fm.getHeight();
            this.m_fontAscent = fm.getAscent();
            if (this.m_step != null) {
                int count;
                w = 0;
                if (this.m_stepCountString != null) {
                    w = fm.stringWidth(this.m_stepCountString) + 2;
                }
                if ((count = this.m_step.getActiveCount()) != 0) {
                    this.m_stepCountString = Integer.toString(count);
                    if (fm.stringWidth(this.m_stepCountString) + 2 > w) {
                        w = fm.stringWidth(this.m_stepCountString) + 2;
                    }
                } else {
                    this.m_stepCountString = null;
                }
                width += w;
                height = this.m_fontHeight;
                this.m_stepCountDim = new Dimension(w, this.m_fontHeight);
            }
            if ((height += s_vGap) == 0) {
                height = this.m_defaultFontHeight;
            }
            this.m_runtimeInfoDim = new Dimension(width, height);
            Rectangle imageRect = this.m_stepUI.getImageBounds();
            this.m_offset = new Point(0, 0);
            this.m_offset.x = (imageRect.width - this.m_runtimeInfoDim.width) / 2;
            this.m_offset.y = -this.m_runtimeInfoDim.height;
            this.m_bUpdate = false;
        }
    }

    public void updateActiveItemCount() {
        if (this.m_step != null) {
            int count = this.m_step.getActiveCount();
            this.m_stepCountString = count != 0 ? Integer.toString(count) : null;
        }
        this.m_bUpdate = true;
    }

    public VWBaseStepUI getBaseStepUI() {
        return this.m_stepUI;
    }

    public VWSIMAnimatorStepUI getAnimatorStepUI() {
        return this;
    }

    public void removeReferences() {
        this.m_parentFrame = null;
        this.m_stepUI = null;
        this.m_step = null;
        this.m_statusIcon = null;
        this.m_date = null;
        this.m_dateString = null;
        this.m_runtimeInfoDim = null;
        this.m_stepCountDim = null;
        this.m_stepCountString = null;
        this.m_offset = null;
        this.m_font = null;
        this.m_fm = null;
        this.m_popup = null;
        this.m_workItemIcon = null;
    }

    public static int getFlashCount() {
        return 1;
    }
}

